function [rep] = sersendget(skt,msg,replen,SER_TIMEOUT)
%function [rep] = sersendget(skt,msg,replen)
% Send packet and receive reply
%format is
%synchar
%swapchar
%checksum lsb
%checksum msb
%len
%msg[len]
% Serial bits added
% 10-June- 2023 - Ian Stothers

pp_commands;
if(nargin<4)
 SER_TIMEOUT=skt.ser.Timeout;
endif
rep=[];

%Make and encode send packet
msg=double(msg(:))';
msg=[1 (sscanf(skt.remoteip,'%d.%d')(2:-1:1))' (sscanf(skt.localip,'%d.%d')(2:-1:1))' size(msg)(2) msg];
%msg=[1 (sscanf(skt.remoteip,'%d.%d'))' (sscanf(skt.localip,'%d.%d'))' size(msg)(2) msg];
len=size(msg)(2);
synchar=hex2dec('a5');


cs=checksum16([len msg]);
oppkg=[synchar synchar cs-(256*floor(cs/256)) floor(cs/256) len msg];

ther=zeros(1,256);
ther(oppkg+1)=1;
oppkg(2)=min(find(ther<1))-1;
idx=find(oppkg==synchar)(2:end);
if (min(size(idx))>0)
  oppkg(idx)=ones(1,max(size(idx)))*oppkg(2);
endif

%flush(skt.ser);
      flushoutput(skt.ser);
      flushinput(skt.ser);

read(skt.ser,skt.ser.NumBytesAvailable,'uchar');
setDTR(skt.ser,0); %enable line drivers
      flushoutput(skt.ser);
      flushinput(skt.ser);
read(skt.ser,skt.ser.NumBytesAvailable,'uchar');
write(skt.ser,oppkg,'uchar');
      flushoutput(skt.ser);

%flush(skt.ser);
%while (skt.ser.NumBytesAvailable<max(size(oppkg)))
 %     flushinput(skt.ser);
%end
%  skt.ser.NumBytesAvailable
%skt.ser.NumBytesAvailable
pause(((max(size(oppkg))*10)/skt.ser.BaudRate)-0.000);
%      flushinput(skt.ser);

setDTR(skt.ser,1);
read(skt.ser,max(size(oppkg)),'uchar');
%read(skt.ser,skt.ser.NumBytesAvailable,'uchar');

if (replen<1)
  rep=[];
  return;
endif

if(tictocwaitn(skt.ser,(replen+IPHSIZE+SPACHSIZE),SER_TIMEOUT)<1)
 return;
endif

got=double(read(skt.ser,skt.ser.NumBytesAvailable,'uchar'));

%scp=find(got==synchar);
%if(min(size(scp))>0) got=got(scp(1):end); end
%if(got(1)==synchar)
%  len=got(5);
%  if (len==got(2)) len=synchar; endif
%  if(tictocwaitn(skt.ser,(5+len-size(got)(2)),SER_TIMEOUT)<1)
%    return;
%  endif
%else
%  return
%end

%got=[got double(read(skt.ser,skt.ser.NumBytesAvailable,'uchar'))];
%rep=[];
s_ind=find(got==synchar);
if(min(size(s_ind))<1)
 got;
 return;
end
msgp=1;

while (max(size(s_ind))>=msgp)
 msge=max(size(got));
 if (msgp<max(size(s_ind))) msge=s_ind(msgp+1)-1; endif
 msg=got(s_ind(msgp):msge);
 size_msg=max(size(msg));
 if (size_msg>4)
   swap=msg(2);
   swind=find(msg==swap);
   msg(swind)=synchar+(0*msg(swind));
   csum=msg(3)+256*msg(4);
   len=msg(5);
   if (size_msg>=(5+len))
    csume=checksum16(msg(5:(5+len)));
   else
    csume=-1;
   endif
     %is it for me?
   if (max(size(msg))<(IPHSIZE+SPACHSIZE))
     rep=[];
     return;
   endif
   if (max(size(msg))<(SPACHSIZE+len))
     rep=[];
     return;
   endif
   msg=msg((SPACHSIZE+1):((SPACHSIZE+1)+len-1));
   iplen=msg(6);
   lip=   [256 1  ]*sscanf(skt.localip,'%d.%d');
   rip=   [256 1  ]*sscanf(skt.remoteip,'%d.%d');
   if ((msg(1)==1)&&(lip==(256*msg(3)+(msg(2))))&&(rip==(256*msg(5)+(msg(4))))&&(csume==csum)&&(iplen<=(max(size(msg))-6)))
     rep=msg(7:(7+iplen-1));
     return
   else
     msgp=msgp+1;
   endif
 endif
endwhile
endfunction

function [ok]=tictocwaitn(ser,bytes,seconds)
  id=tic;
  wlp=1;
  while(wlp>0)
  %     flush(ser); % flush is broken
 %     flushoutput(skt.ser);
 %     flushinput(skt.ser);

    if(ser.NumBytesAvailable>=bytes) wlp=0; ok=1; endif
    if(toc(id)>=seconds) wlp=0; ok=0;endif
  endwhile;
endfunction





